/*
   This program launches two child processes that both
   inherit this process's standard streams. So the two
   child processes share their standard streams with
   each other. (This process does not itself read or
   write anything to the shared streams.)

   Notice that if stdin is the keyboard, then you need
   to type ^z twice to close this program, once for each
   shared input stream.

   Be sure to run this program with a command line like

      C:\>test_shared_streams.exe < big.txt > test.txt

   where big.txt is a fairly large text file (at least
   1 Mb). The result is interesting.
*/
#include <stdio.h>
#include <windows.h>

/* function prototype */
void printError(char* functionName);

int main( int argc, char *argv[])
{
   LPTSTR lpCommandLine1;
   PROCESS_INFORMATION processInfo1;
   STARTUPINFO startInfo1;

   LPTSTR lpCommandLine2;
   PROCESS_INFORMATION processInfo2;
   STARTUPINFO startInfo2;

   ZeroMemory(&startInfo1, sizeof(startInfo1));
   startInfo1.cb = sizeof(startInfo1);
   ZeroMemory(&startInfo2, sizeof(startInfo2));
   startInfo2.cb = sizeof(startInfo2);

   /* set up the command line */
   lpCommandLine1 = "double.exe";

   /* create the child process */
   if( !CreateProcess(NULL, lpCommandLine1, NULL, NULL, TRUE,
                      NORMAL_PRIORITY_CLASS,
                      NULL, NULL, &startInfo1, &processInfo1) )
   {
       printError("CreateProcess");
   }
   else
   {
      fprintf(stderr, "Started double: pid = %d\n", (int)processInfo1.dwProcessId);
   }


   /* set up the command line */
   lpCommandLine2 = "to_upper_case.exe";

   /* create the child process */
   if( !CreateProcess(NULL, lpCommandLine2, NULL, NULL, TRUE,
                      NORMAL_PRIORITY_CLASS,
                      NULL, NULL, &startInfo2, &processInfo2) )
   {
       printError("CreateProcess");
   }
   else
   {
      fprintf(stderr, "Started to_upper_case: pid = %d\n", (int)processInfo2.dwProcessId);
   }


   /* wait for the child processes to end */
   WaitForSingleObject(processInfo1.hProcess, INFINITE);
   WaitForSingleObject(processInfo2.hProcess, INFINITE);

   /* close all the handles */
   CloseHandle(processInfo1.hThread);
   CloseHandle(processInfo1.hProcess);
   CloseHandle(processInfo2.hThread);
   CloseHandle(processInfo2.hProcess);

   return 0;
}



/****************************************************************
   The following function can be used to print out "meaningful"
   error messages. If you call a Win32 function and it returns
   with an error condition, then call this function right away and
   pass it a string containing the name of the Win32 function that
   failed. This function will print out a reasonable text message
   explaining the error and then (if chosen) terminate the program.
*/
void printError(char* functionName)
{
   LPVOID lpMsgBuf;
    int error_no;
    error_no = GetLastError();
    FormatMessage(
         FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
         NULL,
         error_no,
         MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
         (LPTSTR) &lpMsgBuf,
         0,
         NULL
    );
    // Display the string.
    fprintf(stderr, "\n%s failed on error %d: ", functionName, error_no);
    fprintf(stderr, (const char*)lpMsgBuf);
    // Free the buffer.
    LocalFree( lpMsgBuf );
    //ExitProcess(1);  // terminate the program
}//printError
